 /*******************************************************************
 *
 *  DESCRIPTION: Atomic Model Base Station Queue
 *
 *  AUTHOR: Misagh Tavanpour
 *
 *  DATE: 25/10/2012
 *
 *******************************************************************/

 #ifndef __BSQUEUE2_H
 #define __BSQUEUE2_H

 #include "atomic.h"     // class Atomic
 #include "string.h"	 // class String
 #include "list.h"

 class BSQueue2 : public Atomic
 {
   public:
	       BSQueue2( const std::string &name = "BSQueue2" );	//Default constructor
	       virtual std::string className() const { return "BSQueue2"; }
	       ~BSQueue2();

   protected:
	          Model &initFunction();
	          Model &externalFunction( const ExternalMessage & );
	          Model &internalFunction( const InternalMessage & );
	          Model &outputFunction( const InternalMessage & );

   private:
	        const Port &IB0,&IB1,&IB3,&IB4,&IB5,&IB6,&IU1,&Req;
	        Port &Out;
	        Time ProcessTime;
	        typedef list<Value> ElementList ;
	        ElementList elements;
	        int Request;
	        int Qlen;
         	enum State{
			            Idle,       //initial state
			            Push,
			            Pop,
		              };
		    State state;
 };	// class BSQueue2

 #endif   //__BSQUEUE2_H
